# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial phase: cooperate first 3 rounds
    if len(my_history) < 3:
        return "C"
    
    # Check for unconditional strategies
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    if always_c:
        return "D"
    if always_d:
        return "D"
    
    # Middle phase: test opponent's response in round 4
    if len(my_history) == 3:
        if all(move == "C" for move in opp_history[:3]):
            return "D"
        else:
            return opp_history[-1]
    
    # If opponent retaliated in round 5, revert to cooperation
    if len(my_history) == 5 and my_history[3] == "D" and opp_history[4] == "D":
        return "C"
    
    # Final phase: defect last two rounds if mutual cooperation was stable
    if len(my_history) >= 8 and all(move == "C" for move in opp_history[:8]):
        return "D"
    
    # Default to tit-for-tat if adversarial
    if opp_history and opp_history[-1] == "D":
        return "D"
    
    return "C"